package w83a.w83aUtilidadesLibroRegistro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aManager.W83AEjGvDocumento;
import w83a.w83aUtilidadesComunes.W83AInformacionProcedimiento;
import w83a.w83aUtilidadesComunes.W83AProperties;
import w83a.w83aUtilidadesComunes.W83AStringUtil;
import w83a.w83aUtilidadesComunes.W83AWebServiceCall;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;
import w83a.w83aUtilidadesComunes.W83aDateUtil;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class W83aLibroRegistro.
 *
 * @author Deusto Sistemas
 */
public class W83aLibroRegistro {
	
	/**
	 * Gets the libro registro url.
	 *
	 * @return the libro registro url
	 * @throws Exception the exception
	 */
	private static String getLibroRegistroUrl() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("LIBRO_REGISTRO_URL");
	}
	
	/**
	 * Gets the libro registro hora url.
	 *
	 * @return the libro registro hora url
	 * @throws Exception the exception
	 */
	private static String getLibroRegistroHoraUrl() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("LIBRO_REGISTRO_HORA_URL");
	}
	
	/**
	 * Gets the libro registro modelo salida.
	 *
	 * @return the libro registro modelo salida
	 * @throws Exception the exception
	 */
	public static String getLibroRegistroModeloSalida() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("MODELO_SALIDA");
	}
	
	/**
	 * Gets the libro registro modelo entrada.
	 *
	 * @return the libro registro modelo entrada
	 * @throws Exception the exception
	 */
	public String getLibroRegistroModeloEntrada() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("MODELO_ENTRADA");
	}
	
	/**
	 * Gets the app code.
	 *
	 * @return the app code
	 * @throws Exception the exception
	 */
	private static String getAppCode() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("APPLICATION_CODE");
	}
	
	/**
	 * Gets the alta registro.
	 *
	 * @param hora the hora
	 * @param modelo the modelo
	 * @param sentido the sentido
	 * @param entorno the entorno
	 * @param empresa the empresa
	 * @param poblacion the poblacion
	 * @param unidadOrganica the unidad organica
	 * @param observaciones the observaciones
	 * @return the alta registro [0] -> n Registro
	 * 							 [1] -> fecha Registro
	 * @throws Exception the exception
	 */
	public static String[] getAltaRegistro(boolean hora, String modelo, String sentido, String entorno,
			String empresa, String poblacion, String unidadOrganica, String observaciones,
			W83aUsuarioXLNetsBean userBean) throws Exception {
	
		String[] registro = new String[2];
	    registro[0] = null;
	    registro[1] = null;
	    
		if (Q70ListenerUtils.getApplicationProperty("catalogo.ACTIVE").equals("true")){
			
			String host = getLibroRegistroUrl();
			if (hora){
				host = getLibroRegistroHoraUrl();
			}
			String datos = "modelo=" + URLEncoder.encode(modelo, "ISO-8859-1");//NOPMD
			URLDecoder.decode(modelo, "ISO-8859-1");
			datos +="&sentidoLibro="+sentido;//NOPMD
			datos +="&entornoLibro="+entorno;//NOPMD
		    if (empresa!=null && !W83aClsConstantes.VACIO.equals(empresa.trim())){
		    	datos +="&nombreEmpresa="+empresa.trim();//NOPMD
		    }
		    if (poblacion!=null && !W83aClsConstantes.VACIO.equals(poblacion.trim())){
		    	datos +="&poblacionInterlocutor="+poblacion.trim();//NOPMD
		    }
		    if (unidadOrganica!=null && !W83aClsConstantes.VACIO.equals(unidadOrganica.trim())){
		    	datos +="&uo=" + URLEncoder.encode(unidadOrganica, "ISO-8859-1");//NOPMD
		    }
		    if (observaciones!=null && !W83aClsConstantes.VACIO.equals(observaciones.trim())){
		    	datos +="&observaciones=" + URLEncoder.encode(observaciones, "ISO-8859-1");//NOPMD
		    }
		    String temp = getAppCode();
		    if(temp!=null && !W83aClsConstantes.VACIO.equals(temp.trim())){
		    	datos +="&aplic=" + URLEncoder.encode(getAppCode(), "ISO-8859-1");//NOPMD
		    }
		    W83aClsTrazas.trazaDebug(null,"LIBROREGISTRO - URL\n"+datos);
		    
		    StringBuffer contenido = new StringBuffer(W83aClsConstantes.VACIO);
		
		      try {
		        if (datos != null) {
		          // Conexin URL a AltaReg
		          URL url = new URL(host);
		          
		
		          //URLConnection yc = url.openConnection();
		          HttpURLConnection conn = (HttpURLConnection)url.openConnection();
		          if (conn != null) {
		            conn.setDoInput(true);
		            conn.setDoOutput(true);
		            conn.setUseCaches(false);
		
		            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
		            conn.setRequestProperty("Connection", "keep-alive");
		            conn.setRequestProperty("Content-Length", "" + Integer.toString(datos.getBytes().length));
		            conn.setRequestMethod("POST");
		            PrintWriter out = new PrintWriter(conn.getOutputStream());
		            out.print(datos);
		            out.close();
		
		            // Se lee la respuesta del servidor
		            InputStream is = conn.getInputStream();
		            if (is != null) {
		              InputStreamReader isr = new InputStreamReader(is);
		              if (isr != null) {
		                BufferedReader in = new BufferedReader(isr);
		                String inputLine;
		                while ((inputLine = in.readLine()) != null) {
		                  contenido.append(inputLine);
		                }
		                in.close();
		                String cadenaRegistro = contenido.toString();
		                W83aClsTrazas.trazaDebug(null,"LIBROREGISTRO - RTO\n "+cadenaRegistro);
		                String numeroRegistro = cadenaRegistro.substring(0, cadenaRegistro.indexOf("@"));
		                String fechaRegistro = cadenaRegistro.substring(cadenaRegistro.indexOf("@") + 1,
		                    cadenaRegistro.lastIndexOf("@"));
		                	Date fechaRegistroDate;
		                  registro[0] = numeroRegistro;
		                  if (hora){
		                	  fechaRegistroDate = W83aDateUtil.getInstance().getDate(fechaRegistro, "dd/MM/yy HH:mm:ss");
		                	  fechaRegistro = W83aDateUtil.getInstance().getLocaleStringFromDateHora(fechaRegistroDate,W83aClsConstantes.CONSTANTE_CASTELLANO);
		                  }
		                  else{
		                	  fechaRegistroDate = W83aDateUtil.getInstance().getDate(fechaRegistro, "dd/MM/yy");
		                	  fechaRegistro = W83aDateUtil.getInstance().getLocaleStringFromDate(fechaRegistroDate,W83aClsConstantes.CONSTANTE_CASTELLANO);
		                  }
		                  registro[1] = fechaRegistro;
		              }
		            }
		          }
		        } // end if (datos != null)
		      }
		      catch (Exception e) {
		    	  W83aClsTrazas.traza(null,"FALLO EN EL LIBRO DE REGISTRO "+e.getLocalizedMessage());
//		    	  e.printStackTrace();
		    	  W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		    	  W83aClsTrazas.trazaError(null,contenido.toString(),e);
		        registro[0] = null;
		        registro[1] = null;
		        throw new W83aLibroRegistroException();
		      }
		}else{
			registro[0] = "2010RTE00040758";
			 //if (hora){
           	  registro[1] = "07/06/2010 22:10:11";					
             //}else{
           	  //registro[1] = "07/06/2010";					
            // }
		}
		
		W83aClsTrazas.traza(userBean,"n registro "+registro[0]);
		W83aClsTrazas.traza(userBean,"fecha registro "+registro[1]);
		
		//if(1==1){throw new W83aLibroRegistroException();}
        
	  return registro;
	}
	
	public static String[] crearEntradaRegistro(String sessionToken, W83aUsuarioXLNetsBean usuario) throws Exception {
		String result = "";
		String[] registro = new String[2];
	    registro[0] = null;
	    registro[1] = null;
	    
	    W83aClsTrazas.trazaDebug(null, "crearEntradaRegistro: ");
	    
	    W83aClsTrazas.trazaDebug(null, "Q70ListenerUtils.getApplicationProperty('catalogo.ACTIVE'): "+Q70ListenerUtils.getApplicationProperty("catalogo.ACTIVE"));

		try {
			
			if (Q70ListenerUtils.getApplicationProperty("catalogo.ACTIVE").equals("true")){
				
				W83AInformacionProcedimiento info = new W83AInformacionProcedimiento(sessionToken, W83AProperties.getProperty("w83a","catalogo.procedureId"));
				
				String jpdMethod = W83AProperties.getProperty("w83a","registro.procedure.crearentrada");
				W83aClsTrazas.trazaDebug(null, "===> 3 jpdMethod: " + jpdMethod);
				
				MessageFactory mfactory = MessageFactory.newInstance();
				
				SOAPMessage message = mfactory.createMessage();
				
				SOAPPart soapPart = message.getSOAPPart();
				
				SOAPEnvelope envelope = soapPart.getEnvelope();

				SOAPBody body = envelope.getBody();
				
				Name name = envelope.createName(jpdMethod, "",
						"http://www.openuri.org/");
				
				
				SOAPBodyElement element = body.addBodyElement(name);
				

				SOAPElement symbol = element.addChildElement(envelope.createName("sSessionToken"));
				symbol.addTextNode(sessionToken);
				
				symbol = element.addChildElement(envelope.createName("sXmlContextRegistry"));
				
				StringBuffer str=new StringBuffer();
				str.append("<?xml version='1.0' encoding='UTF-8'?><contextRegistry xmlns='com/ejie/folderManagement/xml'><procedureID>");
				str.append(W83AProperties.getProperty("w83a","catalogo.procedureId"));
				str.append("</procedureID><procedureName><language locale='eu' xmlns='com/ejie/mbt/xml'>");
				str.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","aplicacion.titulo","eu",null));
				str.append("</language><language locale='es' xmlns='com/ejie/mbt/xml'>");
				str.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","aplicacion.titulo","es",null));
				str.append("</language>");
				str.append("</procedureName><managingUnitID>");
				//2343
				str.append(info.getIdOrganoGestor());
				str.append("</managingUnitID><managingUnitName><language locale='eu'>");
				str.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu","eu",null));
				str.append("</language><language locale='es'>");
				str.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es","es",null));
				str.append("</language></managingUnitName>");
				str.append("<registryTopicCode>");
				str.append(W83AProperties.getProperty("w83a","catalogo.procedureId"));
				str.append("</registryTopicCode><registrySenderId>");
				str.append(usuario.getDniUsuario());
				W83aClsTrazas.trazaDebug(null, "usuario.getDniUsuario(): "+usuario.getDniUsuario());
				str.append("</registrySenderId><registrySenderName><description xmlns='com/ejie/mbt/xml'><language locale='es'>");
				str.append(usuario.getNombrePersona());
				W83aClsTrazas.trazaDebug(null, "usuario.getNombrePersona(): "+usuario.getNombrePersona());
				str.append("</language></description>");
				str.append("</registrySenderName><registryAddresseeCode>");
				//2343
				str.append(info.getIdOrganoGestor());
				str.append("</registryAddresseeCode><registryAddresseeName><description xmlns='com/ejie/mbt/xml'><language locale='eu'>");
				str.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu","eu",null));
				str.append("</language><language locale='es'>");
				str.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es","es",null));
				str.append("</language></description></registryAddresseeName><language>eu</language></contextRegistry>");
			
				symbol.addTextNode(str.toString());
				
				SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
				
				SOAPConnection con = factory.createConnection();
				
				String url = W83AProperties.getProperty("w83a",
						"url.ws.crearEntradaRegistro");
				W83aClsTrazas.trazaDebug(null, "url: " + url);
				
				//System.out.println("url="+url);
				
				if (log.isLoggable(Level.INFO)){
					log.info("publicarNotificacion");
					log.info("Metodo="+jpdMethod);
					log.info("url="+url);
				}
				if (log.isLoggable(Level.INFO)){
					log.info("***message="+message);
				}
				SOAPMessage responseWebServ = con.call(message, url);
				result = W83AWebServiceCall.getResultado(responseWebServ);
				W83aClsTrazas.trazaDebug(null, "===>result libro de registrooooooooooooooooooo:"+result);
				W83aClsTrazas.trazaDebug(null, "===>result libro de registrooooooooooooooooooo:"+W83AStringUtil.obtenerPatronInicioFinSinComent(result, "registryNumber"));
				W83aClsTrazas.trazaDebug(null, "===>result libro de registrooooooooooooooooooo:"+W83AStringUtil.obtenerPatronInicioFinSinComent(result, "registryTimestamp"));
				registro[0] = W83AStringUtil.obtenerPatronInicioFinSinComent(result, "registryNumber");
	           	registro[1] = W83AStringUtil.obtenerPatronInicioFinSinComent(result, "registryTimestamp");
	           	
	           	W83aClsTrazas.trazaDebug(null, "numreg libro: "+registro[0]);
			}else{
				registro[0] = "2010RTE00040758";
	           	registro[1] = "07/06/2010 22:10:11";					
			}
		
			if (log.isLoggable(Level.INFO)){
				log.info("sessionToken="+sessionToken);
				log.info("sXmlContextRegistry="+"");
				log.info("-->" + result);
			}
		
			if (result.startsWith("Fallo")){
				result="";
				W83aClsTrazas.trazaDebug(null, "===> 8 Fallo:"+result);
			}
		
			
			return registro;
			
		} catch (IOException ioe) {
			W83aClsTrazas.trazaDebug(null, "===> 9 IOException: " + ioe.getMessage());
			result="";
			
		} catch (Exception ex) {
			W83aClsTrazas.trazaDebug(null, "===> 10 Exception: " + ex.getMessage());
			result="";
		}

		return registro;
	}

	/** The instance. */
	private static W83aLibroRegistro instance = null;
	
	/**
	 * Gets the single instance of W83aLibroRegistro.
	 *
	 * @return single instance of W83aLibroRegistro
	 */
	public static W83aLibroRegistro getInstance(){
		if(instance==null){
			instance = new W83aLibroRegistro();
		}
		return instance;
	}
	
	private static final Logger log = Logger.getLogger(W83AEjGvDocumento.class.getName());
}
